﻿using AzObs.Lib.Mapper;
using AzObs.Lib.Models;
using AzObs.Lib.Services;
using AzObs.Lib.Utils;
using System;
using System.Reflection;
using System.Windows.Forms;

namespace AzObserveUI
{
    public partial class MainForm : Form
    {
        private ObserveServiceBase _service = null;

        /// <summary>
        /// constractor
        /// </summary>
        public MainForm()
        {
            InitializeComponent();
            InitFormControl();
            LoadSettings();
        }


        private void InitFormControl()
        {
            // init ICON
            var icon = System.Drawing.Icon.ExtractAssociatedIcon(
                Assembly.GetEntryAssembly().Location);
            this.Icon = icon;

        }


        private void LoadSettings()
        {
            AppConfig config;
            ObserveSetting observeSetting = null;

            config = ConfigMapper.GetConfig();

            try {
                observeSetting = JsonMapper.GetMappedObjects(config.SettingJson);
            }               
            catch(Exception e) {
                MessageBox.Show(e.Message, "json file Error.");
                Environment.Exit(1);
            }

            InitFormStyle(observeSetting);

            _service = new VerticalFormObserveService(config, observeSetting);
            _service.InitDisplayControls(PnlScroll);
        }


        private void InitFormStyle(ObserveSetting observeSetting)
        {
            if (observeSetting.EnableBackgroundColor)
            {
                this.BackColor = ColorUtil.GetColor(observeSetting.BackgroundColor);
            }
        }


        private void BtnStart_Click(object sender, EventArgs e)
        {
            if (_service.SwitchObserveRunningState(this, PnlScroll))
            {
                BtnStart.Text = "動作中断(&S)";
            }
            else {
                BtnStart.Text = "動作開始(&S)";
            }
        }


        private void btnReset_Click(object sender, EventArgs e)
        {
            _service.InitDisplayControls(PnlScroll);
        }


        private void PnlScroll_Resize(object sender, EventArgs e)
        {
            this.Height = PnlScroll.Location.Y + PnlScroll.Height + 1;
        }
    }
}
