﻿using System;
using System.Drawing;
using System.Text.RegularExpressions;

namespace AzObs.Lib.Utils
{
    /// <summary>
    /// Color Utility
    /// </summary>
    public static class ColorUtil
    {

        private const string HEX_PATTERN = "^[a-fA-F0-9]{6}$";

        /// <summary>
        /// get Color by Hex RGB value or Color Name.
        /// </summary>
        /// <param name="colorValue"></param>
        /// <returns></returns>
        public static Color GetColor(string colorValue) {

            if (Regex.IsMatch(colorValue, HEX_PATTERN)) {
                return Color.FromArgb(
                    Convert.ToInt32(colorValue.Substring(0, 2), 16),
                    Convert.ToInt32(colorValue.Substring(2, 2), 16),
                    Convert.ToInt32(colorValue.Substring(4, 2), 16)
                );
            }

            return Color.FromName(colorValue);
        }
    }
}
