﻿using AzObs.Lib.Models;
using System.Drawing;
using System.Linq;
using System.Windows.Forms;

namespace AzObs.Lib.Services
{
    /// <summary>
    /// Subclass of ObserveServiceBase, Implement With vertically order items.
    /// </summary>
    public class VerticalFormObserveService : ObserveServiceBase
    {

        /// <summary>
        /// constractor
        /// </summary>
        /// <param name="config"></param>
        public VerticalFormObserveService(AppConfig config, ObserveSetting observeSetting) 
            : base(config, observeSetting)
        {
        }


        /// <summary>
        /// Init Display Controls.(implement with vertically order items.)
        /// </summary>
        /// <param name="parentControl"></param>
        public override void InitDisplayControls(Control parentControl)
        {
            parentControl.Controls.Clear();

            int i = 0;
            Label lastItem = null;

           foreach (var item in ObserveSetting.ObserveItems.OrderBy(c => c.Order))
           {
                var lbl = CreateItemLabel(item);
                lbl.Location = new Point(parentControl.Location.X + 1, (lbl.Height * i++) + 1);
                lastItem = lbl;
                parentControl.Controls.Add(lbl);
            }

            parentControl.Height = parentControl.Location.Y + lastItem.Location.Y + lastItem.Height + 3;
        }
    }
}
