﻿using AzObs.Lib.Models;
using System.IO;
using System.Linq;
using System.Runtime.Serialization.Json;
using System.Text;

namespace AzObs.Lib.Mapper
{
    public static class JsonMapper
    {
        /// <summary>
        /// mapping json to item Objects.
        /// </summary>
        /// <param name="observeItems"></param>
        /// <returns></returns>
        public static ObserveSetting GetMappedObjects(string jsonPath)
        {

            ObserveSetting observeSetting;

            string inFilePath = jsonPath;

            using (var sr = new StreamReader(inFilePath, Encoding.UTF8))
            {
                var serializer = new DataContractJsonSerializer(typeof(ObserveSetting));
                observeSetting = (ObserveSetting)serializer.ReadObject(sr.BaseStream);
            }


            // set item order.
            foreach (var element in observeSetting.ObserveItems.Select((item, index) => new { item, index }))
            {
                element.item.Order = element.index;
            }

            return observeSetting;
        }

    }
}
