﻿using AzObs.Lib.Models;
using System.Configuration;
using System.Text;

namespace AzObs.Lib.Mapper
{
    public static class ConfigMapper
    {

        /// <summary>
        /// mapping appSettings to config object.
        /// </summary>
        public static AppConfig GetConfig() 
        {
            var config = new AppConfig();
            config.TargetDir = ConfigurationManager.AppSettings["TARGET_DIR"];
            config.TargetExt = ConfigurationManager.AppSettings["TARGET_EXT"];
            config.SettingJson = ConfigurationManager.AppSettings["SETTING_JSON"];
            config.Encoding = Encoding.GetEncoding(ConfigurationManager.AppSettings["TEXT_ENCODE"]);

            return config;
        }
    }
}
